﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AP8___Delahousse_Blanchard_Maéven
{
    public partial class Calcul : Form
    {
        public Calcul()
        {
            InitializeComponent();
        }

        private void tb_masque_decimal_TextChanged(object sender, EventArgs e)
        {

        }

        private void Calcul_Load(object sender, EventArgs e)
        {
            //Textbox non modifiables
            tb_masque_decimal.Enabled = false;
            tb_masque_binaire.Enabled = false;
            tb_nbhotes.Enabled = false;
            tb_classe.Enabled = false;
            tb_adresse_reseau.Enabled = false;
            tb_nbsousreseaux.Enabled = false;
            tb_nvcidr.Enabled = false;

            //5) Calcul du masque en binaire
            Global.cidr_binaire = "";
            int cp_cidr = Global.cidr;
            int compteur = 1;
            for (int i = 0; i < 35; i++)
            {
                if (compteur % 9 == 0)
                {
                    Global.cidr_binaire += ".";
                    compteur = 1;
                    cp_cidr -= 8;
                }
                else if (compteur <= cp_cidr)
                {
                    Global.cidr_binaire += "1";
                    compteur += 1;
                }
                else
                {
                    Global.cidr_binaire += "0";
                    compteur += 1;
                }

            }

            //Affichage du masque en binaire
            tb_masque_binaire.Text = Global.cidr_binaire;

            //5) Calcul du masque de binaire à décimal
            Global.masque_decimal = "";
            //1ère étape : On chaque partie binaire de notre masque binaire dans un nouveau tableau
            string bloc_bin = "";
            int compteur_bin = 0;

            for (int i = 0; i < Global.cidr_binaire.Length; i++)
            {
                if (Global.cidr_binaire[i].ToString() != ".")
                {
                    bloc_bin += Global.cidr_binaire[i];
                }
                else
                {
                    Global.tab_binaire[compteur_bin] = bloc_bin;
                    bloc_bin = "";
                    compteur_bin += 1;
                }
            }
            Global.tab_binaire[compteur_bin] = bloc_bin;

            //2ème étape : On transforme chaque partie binaire en décimal et chaque valeur obtenue pour chaque partie binaire est stockée dans un autre tableau pour les stocker et les traiter après.
            int value = 0;
            for (int i = 0; i <= 3; i++)
            {
                value = 0;
                for (int j = 0; j < 8; j++)
                {
                    if (Global.tab_binaire[i][j] == '1')
                    {
                        value += (int)Math.Pow(2, 7 - j);
                    }
                }
                Global.tab_entiers[i] = (byte)value;
            }

            //3ème étape : Créer le masque avec les valeurs décimales entrées dans le dernier tableau :
            for (int i = 0; i <= 3; i++)
            {
                if (i != 3)             //On regarde s'il faut rajouter un point derrière chaque valeur, si c'est la dernière, pas besoin
                {
                    Global.masque_decimal += Global.tab_entiers[i].ToString() + ".";
                }
                else
                {
                    Global.masque_decimal += Global.tab_entiers[i].ToString();
                }
            }

            //Affichage du masque en décimal
            tb_masque_decimal.Text = Global.masque_decimal;

            //6) Déterminer l'adresse réseau

            Global.adresse_reseau = "";
            /*
            Rappel des variables :
            Global.tab : Tableau valeurs décimales Adresse IP
            Global.tab_entiers : Tableau valeurs décimales Masque
            Global.tab_reseau : Tableau valeurs décimales Adresse réseau (vide pour l'instant)
            */

            //1ère étape : Trouver la partie de l'adresse qui va changer
            //La variable Global.indice va servir à garder en mémoire l'indice de la valeur qu'on va comparer dans notre futur ET logique

            bool simple = false;           //Variable qui va tester si on est dans un cas facile de calcul de l'adresse réseau (que des 255 ou des 0 dans le masque)
                                           //ou si c'est une situation plus complexe, par défault on suppose que le calcul de l'adresse réseau est complexe

            if (Global.cidr == 0 || Global.cidr == 8 || Global.cidr == 16 || Global.cidr == 24 || Global.cidr == 32)
            {
                simple = true;
            }

            for (int i = 0; i <= 3; i++)
            {
                if (Global.tab_entiers[i] == 255)
                {
                    Global.tab_reseau[i] = (byte)Global.tab[i];
                }
                else if (Global.tab_entiers[i] == 0)
                {
                    Global.tab_reseau[i] = 0;
                }
                else
                {
                    Global.indice = i;
                }
            }

            int v_masque = Global.tab_entiers[Global.indice];
            int v_adresse = Global.tab[Global.indice];
            string v_masque_bin = "";
            string v_adresse_bin = "";
            int v_reseau = 0;
            string v_reseau_bin = "";

            if (simple == false)             //Dans le cas où le calcul de l'adresse réseau est plus complexe, on a besoin de plus d'étapes pour la déterminer
            {

                //Si on a un masque qui ne possède pas uniquement des 255 et des 0, on est dans une situation plus complexe, d'autres étapes dont donc nécessaires :
                //2ème étape : Convertir la valeur décimale du masque et de l'adresse IP que l'on doit comparer en binaire

                for (int i = 7; i >= 0; i--)
                {
                    //Conversion pour valeur décimale du masque
                    if (v_masque >= (int)Math.Pow(2, i))
                    {
                        v_masque_bin += "1";
                        v_masque -= (int)Math.Pow(2, i);
                    }
                    else
                    {
                        v_masque_bin += "0";
                    }

                    //Conversion pour valeur décimale de l'adresse
                    if (v_adresse >= (int)Math.Pow(2, i))
                    {
                        v_adresse_bin += "1";
                        v_adresse -= (int)Math.Pow(2, i);
                    }
                    else
                    {
                        v_adresse_bin += "0";
                    }
                }

                //3ème étape : ET logique entre les valeurs décimales

                for (int i = 0; i <= 7; i++)
                {
                    if (v_masque_bin[i] == '1' && v_adresse_bin[i] == '1')
                    {
                        v_reseau_bin += "1";
                    }
                    else
                    {
                        v_reseau_bin += "0";
                    }
                }

                //4ème étape : Conversion en décimal de la valeur binaire de l'adresse réseau

                for (int i = 0; i <= 7; i++)
                {
                    if (v_reseau_bin[i] == '1')
                    {
                        v_reseau += (int)Math.Pow(2, 7 - i);
                    }
                }


                //On peut maintenant affecter la valeur décimale au tableau
                Global.tab_reseau[Global.indice] = (byte)v_reseau;
            }

            //5ème étape : On transforme notre tableau en chaine de caractère pour avoir l'adresse réseau en une seule partie

            for (int i = 0; i <= 3; i++)
            {
                if (i != 3)
                {
                    Global.adresse_reseau += Global.tab_reseau[i] + ".";
                }
                else
                {
                    Global.adresse_reseau += Global.tab_reseau[i];
                }
            }

            //Affichage de l'adresse réseau
            tb_adresse_reseau.Text = Global.adresse_reseau;

            //7) Calcul du nombre d'hôtes
            int nb_zero = 32 - Global.cidr;                  //On calcule le nombre de zéros du masque

            if (nb_zero == 0)
            {
                Global.nbhotes = 0;
            }
            else
            {
                Global.nbhotes = (uint)(Math.Pow(2, nb_zero)) - 2;       //Calcul : 2^nb_de_zeros - 2
            }

            tb_nbhotes.Text = Global.nbhotes.ToString();


            //8) Déterminer la classe
            int v_classe = Global.tab[0];
            if (v_classe <= 126)
            {
                Global.classe = 'A';
            }

            else if (v_classe <= 191)
            {
                Global.classe = 'B';
            }

            else if (v_classe <= 223)
            {
                Global.classe = 'C';
            }

            else if (v_classe <= 239)
            {
                Global.classe = 'D';
            }
            else
            {
                Global.classe = 'E';
            }
            tb_classe.Text = Global.classe.ToString();


            //9) Calcul du nombre de sous-réseaux
            byte nb_un = 0;         //On initialise une variable pour calculer le nombre de 1

            if (Global.classe == 'A')
            {
                nb_un = (byte)(Global.cidr - 8);
                if (nb_un >= 0)             //On vérifie que le cidr entré comporte plus de 1 que le masque par défaut de la classe
                {
                    Global.nb_sousreseaux = (int)Math.Pow(2, Global.cidr - 8);      //8 car la classe A a un masque par défaut de 255.0.0.0
                }
                else
                {
                    Global.nb_sousreseaux = 1;
                }
            }

            else if (Global.classe == 'B')
            {
                nb_un = (byte)(Global.cidr - 16);
                if (nb_un >= 0)             //On vérifie que le cidr entré comporte plus de 1 que le masque par défaut de la classe
                {
                    Global.nb_sousreseaux = (int)Math.Pow(2, Global.cidr - 16);      //8 car la classe A a un masque par défaut de 255.255.0.0
                }
                else
                {
                    Global.nb_sousreseaux = 1;
                }
            }

            else if (Global.classe == 'C')
            {
                nb_un = (byte)(Global.cidr - 24);
                if (nb_un >= 0)             //On vérifie que le cidr entré comporte plus de 1 que le masque par défaut de la classe
                {
                    Global.nb_sousreseaux = (int)Math.Pow(2, Global.cidr - 24);      //8 car la classe A a un masque par défaut de 255.255.255.0
                }
                else
                {
                    Global.nb_sousreseaux = 1;
                }
            }

            else
            {
                Global.nb_sousreseaux = 0;          //Pas de sous-réseaux disponibles pour les classes D et E
            }

            tb_nbsousreseaux.Text = Global.nb_sousreseaux.ToString();

        }

        private void btn_valider_Click(object sender, EventArgs e)
        {
            //10) Afficher un cidr à partir d'un nombre de sous-réseaux souhaité
            Global.nv_cidr = Global.cidr;
            Global.nb_sousreseaux_souhaite = int.Parse(tb_nbsouhaite.Text);

            byte compteur = 0;
            while ((int)Math.Pow(2, compteur) < Global.nb_sousreseaux_souhaite)         //Tant que 2^compteur est strictement inférieur au nombre de sous-réseaux souhaité, on continue pour trouver
                                                                                        //le la valeur pour laquelle 2^compteur est supérieure ou égale au nombre de sous-réseaux
            {
                compteur += 1;
            }
            Global.nv_cidr = (byte)(Global.cidr + compteur);

            if (Global.nv_cidr > 32)
            {
                MessageBox.Show("Quantité de sous-réseaux demandée trop grande.");
            }
            else
            {
                tb_nvcidr.Text = Global.nv_cidr.ToString();
            }
            
        }

        private void btn_retour_Click(object sender, EventArgs e)
        {
            Form1 retour = new Form1();
            retour.Show();
            this.Close();
        }

        private void btn_quitter2_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }
    }
}
